/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp.display;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.ParameterItemDisplayCellEditor;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TheodoliteValueCellEditor
extends ParameterItemDisplayCellEditor {
    protected JPanel fEditorComponent = new JPanel();
    private JComboBox fDir;
    private JComboBox fSegmentType;
    private EditableNumericSpinner fValue;
    private JLabel fJLabel;
    private String fIdentifier;
    private AstronomicalClockParameter.Theodolite fOriginalValue;

    public TheodoliteValueCellEditor() {
        this.fEditorComponent.setLayout(new FlowLayout());
        this.fEditorComponent.setFocusCycleRoot(true);
        this.fDir = new JComboBox();
        this.fJLabel = new JLabel();
        String[] data = new String[]{"\u00b0", "'", "\""};
        this.fSegmentType = new JComboBox<String>(data);
        this.fSegmentType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = TheodoliteValueCellEditor.this.fSegmentType.getSelectedIndex();
                if (index == 0) {
                    TheodoliteValueCellEditor.this.fValue.setMinMax(0, 90);
                    if (TheodoliteValueCellEditor.this.fParameterItem.getIdentifier().equals("LO")) {
                        TheodoliteValueCellEditor.this.fValue.setMinMax(0, 180);
                    }
                    TheodoliteValueCellEditor.this.fValue.setValue(TheodoliteValueCellEditor.this.fOriginalValue.getDegree());
                } else if (index == 1) {
                    TheodoliteValueCellEditor.this.fValue.setMinMax(0, 59);
                    TheodoliteValueCellEditor.this.fValue.setValue(TheodoliteValueCellEditor.this.fOriginalValue.getMinute());
                } else if (index == 2) {
                    TheodoliteValueCellEditor.this.fValue.setMinMax(0, 59);
                    TheodoliteValueCellEditor.this.fValue.setValue(TheodoliteValueCellEditor.this.fOriginalValue.getSecond());
                }
            }
        });
        this.fValue = new EditableNumericSpinner();
        this.fEditorComponent.add(this.fJLabel);
        this.fEditorComponent.add(this.fDir);
        this.fEditorComponent.add(this.fValue);
        this.fEditorComponent.add(this.fSegmentType);
    }

    public Object getCellEditorValue() {
        this.fOriginalValue.setDir(this.fDir.getSelectedIndex());
        int index = this.fSegmentType.getSelectedIndex();
        if (index == 0) {
            this.fOriginalValue.setDegree(this.fValue.getValue());
        } else if (index == 1) {
            this.fOriginalValue.setMinute(this.fValue.getValue());
        } else if (index == 2) {
            this.fOriginalValue.setSecond(this.fValue.getValue());
        }
        this.fParameterItem.getParameter().fireParameterSetEvent();
        return this.fParameterItem;
    }

    public Component getDisplayCellEditorComponent(LogoDisplay logoDisplay, Object displayElement, boolean isSelected, int row, int column) {
        super.getDisplayCellEditorComponent(logoDisplay, displayElement, isSelected, row, column);
        if (this.fParameterItem != null) {
            Object parameterItemValue = ((ParameterItem)displayElement).getValue();
            this.fIdentifier = ((ParameterItem)displayElement).getIdentifier();
            this.fEditorComponent.setToolTipText(this.fIdentifier);
            this.fOriginalValue = (AstronomicalClockParameter.Theodolite)parameterItemValue;
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            if (this.fOriginalValue.getType() == 1) {
                model.addElement("N");
                model.addElement("S");
            } else {
                model.addElement("E");
                model.addElement("W");
            }
            this.fDir.setModel(model);
            this.fDir.setSelectedIndex(this.fOriginalValue.getDir());
            this.fSegmentType.setSelectedIndex(0);
            this.fValue.setValue(this.fOriginalValue.getDegree());
            this.fJLabel.setText(this.fIdentifier + ": ");
        }
        return this.fEditorComponent;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }
}

